/* Antarmuka dengan Sensor Kelembaban Tanah - Basic IoT Kit ESP32
 * Project : Monitoring dengan Sensor Kelembaban Tanah
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP32 WiFi dan Firebase ESP32
#include <WiFi.h>
#include <FirebaseESP32.h>

// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Analog Sensor (A0) terhubung ke PIN 34 ESP32
#define SM_PIN  34

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data ADC dan data konversi sensor
int sm_adc, sm_value;
// Variabel untuk menyimpan karakter data sensor
char sm_data[3];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
  
  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() { 
  // Membaca data ADC sensor
  // ADC disimpan pada 'as_adc'
  // Data konversi disimpan pada 'as_value'
  sm_adc   = analogRead(SM_PIN);
  // Nilai 1320 didapatkan dengan mencelupkan sensor ke air
  // Nilai *1320 di ganti dengan nilai adc air
  // Ubah nilai *760 untuk sensor hujan
  sm_value = map(sm_adc, 0, 1320, 0, 100);  // Nilai 0-4095
  if(sm_value > 100) sm_value = 100;

  // Mencetak data pada serial monitor
  Serial.println("ADC   : " + String(sm_adc));
  Serial.println("Nilai : " + String(sm_value) + " %");
  Serial.println();

  // Mengirim data sensor ke database
  // dengan alamat *user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/" + "gauge1", sm_value);
  
  // Menampilkan data kelembaban tanah pada OLED Display
  display.setTextSize(1);             // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);        // Mengatur teks warna putih
  display.setCursor(0,0);             // Mengatur kursor (x:0, y:0)
  display.print("Soil Moisture (%)" );// Mencetak Teks "Soil Moisture:"
  display.setTextSize(2);             // Mengatur ukuran teks = 2
  display.setCursor(0,10);            // Mengatur kursor (x:0, y:10)
  display.print(sm_value);            // Mencetak Nilai suhu

  // Menampilkan data ADC pada OLED Display
  display.setTextSize(1);       // Mengatur ukuran teks = 1
  display.setTextColor(WHITE);  // Mengatur teks warna putih
  display.setCursor(0,35);      // Mengatur kursor (x:0, y:0)
  display.print("ADC SM");         // Mencetak Teks "ADC:"
  display.setTextSize(2);       // Mengatur ukuran teks = 2
  display.setCursor(0,45);      // Mengatur kursor (x:0, y:45)
  display.print(sm_adc);        // Mencetak Nilai ADC Soil Moisture

  display.display();            // Menampilkan data
  display.clearDisplay();       // Membersihkan tampilan display
}